<?php
// 添加管理菜单
function custom_comments_add_admin_menu() {
    add_menu_page(
        '评论转移设置',          // 页面标题
        '评论转移',             // 菜单标题
        'manage_options',       // 权限要求
        'custom-comments-style', // 菜单slug
        'custom_comments_admin_page', // 回调函数
        'dashicons-format-chat', // 图标
        80                      // 菜单位置
    );
}
add_action('admin_menu', 'custom_comments_add_admin_menu');

// 注册设置
function custom_comments_settings_init() {
    register_setting('custom_comments_style', 'custom_comments_settings');
    
    add_settings_section(
        'custom_comments_style_section', 
        '评论样式设置', 
        'custom_comments_settings_section_callback', 
        'custom_comments_style'
    );

    add_settings_field(
        'default_style', 
        '默认样式', 
        'custom_comments_default_style_render', 
        'custom_comments_style', 
        'custom_comments_style_section'
    );

    add_settings_field(
        'enable_custom_css', 
        '启用自定义CSS', 
        'custom_comments_enable_css_render', 
        'custom_comments_style', 
        'custom_comments_style_section'
    );

    add_settings_field(
        'custom_css_code', 
        '自定义CSS代码', 
        'custom_comments_custom_css_render', 
        'custom_comments_style', 
        'custom_comments_style_section'
    );
}
add_action('admin_init', 'custom_comments_settings_init');

// 设置部分回调
function custom_comments_settings_section_callback() {
    echo '<p>配置评论显示样式和自定义选项</p>';
}

// 默认样式选择框
function custom_comments_default_style_render() {
    $options = get_option('custom_comments_settings');
    ?>
    <select name='custom_comments_settings[default_style]'>
        <option value='default' <?php selected($options['default_style'], 'default'); ?>>默认样式</option>
        <option value='modern' <?php selected($options['default_style'], 'modern'); ?>>现代样式</option>
        <option value='minimal' <?php selected($options['default_style'], 'minimal'); ?>>极简样式</option>
    </select>
    <?php
}

// 启用自定义CSS复选框
function custom_comments_enable_css_render() {
    $options = get_option('custom_comments_settings');
    ?>
    <input type='checkbox' name='custom_comments_settings[enable_custom_css]' <?php checked($options['enable_custom_css'], 1); ?> value='1'>
    <label>启用自定义CSS覆盖</label>
    <?php
}

// 自定义CSS文本框
function custom_comments_custom_css_render() {
    $options = get_option('custom_comments_settings');
    ?>
    <textarea cols='80' rows='10' name='custom_comments_settings[custom_css_code]'><?php echo esc_textarea($options['custom_css_code']); ?></textarea>
    <p class="description">在此添加您的自定义CSS代码，它将覆盖默认样式</p>
    <?php
}

// 管理页面内容
function custom_comments_admin_page() {
    ?>
    <div class="wrap">
        <h1>评论样式设置</h1>
        
        <div class="card">
            <h2>插件使用说明</h2>
            <p>本插件提供多种评论显示样式，可通过短代码在任何页面调用。</p>
            <h3>基本用法</h3>
            <p><code>[custom_comments]</code> - 显示当前文章的评论</p>
            <p><code>[custom_comments post_id="123"]</code> - 显示指定ID文章的评论</p>
            
            <h3>高级参数</h3>
            <ul>
                <li><strong>style</strong>: 指定样式(default/modern/minimal)</li>
                <li><strong>count</strong>: 显示评论数量</li>
                <li><strong>post_id</strong>: 指定文章ID</li>
            </ul>
        </div>
        
        <form action='options.php' method='post'>
            <?php
            settings_fields('custom_comments_style');
            do_settings_sections('custom_comments_style');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}



