<?php
class ACM_Page_Loader {
    public static function init() {
        add_shortcode('acm_load_page', [__CLASS__, 'shortcode_load_page']);
        add_action('wp_ajax_acm_get_page_content', [__CLASS__, 'ajax_get_page_content']);
    }

    public static function shortcode_load_page($atts) {
        $atts = shortcode_atts([
            'id' => 0,
            'slug' => '',
            'excerpt' => false
        ], $atts);

        if (!empty($atts['slug'])) {
            $page = get_page_by_path($atts['slug']);
            $atts['id'] = $page ? $page->ID : 0;
        }

        return self::get_page_content($atts['id'], $atts['excerpt']);
    }

    public static function ajax_get_page_content() {
        $page_id = intval($_POST['page_id']);
        wp_send_json_success([
            'content' => self::get_page_content($page_id)
        ]);
    }

    private static function get_page_content($page_id, $excerpt = false) {
        $content = '';
        $page = get_post($page_id);
        
        if ($page) {
            $content = $excerpt ? get_the_excerpt($page) : apply_filters('the_content', $page->post_content);
        }
        
        return $content;
    }
}
