<?php
// 注册评论标签分类法
function register_comment_tags() {
    register_taxonomy(
        'comment_tag',
        'comment',
        array(
            'label' => '评论标签',
            'hierarchical' => false,
            'public' => true,
            'show_ui' => true
        )
    );
}
add_action('init', 'register_comment_tags');

// 获取请求的标签参数
$requested_tag = isset($_GET['comment_tag']) ? sanitize_text_field($_GET['comment_tag']) : '';

// 设置每页显示评论数
$comments_per_page = 10;
$paged = max(1, get_query_var('paged'));

// 构建基础查询参数
$base_args = array(
    'post_id' => get_the_ID(),
    'type' => 'comment',
    'status' => 'approve',
    'user_id' => get_the_author_meta('ID'),
    'orderby' => 'comment_date',
    'order' => 'DESC'
);

// 如果有标签筛选请求
if (!empty($requested_tag)) {
    $base_args['tax_query'] = array(
        array(
            'taxonomy' => 'comment_tag',
            'field' => 'slug',
            'terms' => $requested_tag
        )
    );
}

// 获取当前页评论
$current_comments_args = array_merge($base_args, array(
    'number' => $comments_per_page,
    'offset' => ($paged - 1) * $comments_per_page
));
$current_comments = get_comments($current_comments_args);

// 获取最新一条评论（用于折叠显示）
$latest_comment_args = array_merge($base_args, array('number' => 1));
$latest_comment = get_comments($latest_comment_args);

// 计算总评论数
$count_args = array_merge($base_args, array('count' => true));
$total_comments = get_comments($count_args);

// 获取所有可用标签
$tags = get_terms(array(
    'taxonomy' => 'comment_tag',
    'hide_empty' => false
));

// 显示标签筛选器
//if (!empty($tags)) {
  //  echo '<div class="comment-tag-filter">';
    //echo '<span>按标签筛选：</span>';
   // echo '<a href="'.remove_query_arg('comment_tag').'" class="'.(empty($requested_tag) ? 'active' : '').'">全部</a>';
   // foreach ($tags as $tag) {
     //   echo '<a href="'.add_query_arg('comment_tag', $tag->slug).'" class="'.($requested_tag == $tag->slug ? 'active' : '').'">'.$tag->name.'</a>';
    //}
    //echo '</div>';
//}

// 显示最新一条评论
if (!empty($latest_comment)) {
    echo '<div class="latest-comment">';
    foreach ($latest_comment as $comment) {
        echo '<div class="comment-item">';
        echo '<div class="comment-date">' . get_comment_date('Y年m月d日') . '</div>';
        echo '<div class="comment-content">' . wpautop(get_comment_text($comment->comment_ID)) . '</div>';
        
        // 显示评论标签
        $comment_tags = get_the_terms($comment->comment_ID, 'comment_tag');
        if (!empty($comment_tags)) {
            echo '<div class="comment-tags">';
            foreach ($comment_tags as $tag) {
                echo '<span class="comment-tag">'.$tag->name.'</span>';
            }
            echo '</div>';
        }
        
        echo '</div>';
    }
    echo '</div>';
}

// 显示"显示更多"按钮（当评论多于1条时）
if ($total_comments > 1) {
    echo '<button class="comments-toggle">历史记录 (' . ($total_comments - 1) . ')</button>';
}

// 显示完整评论列表（初始隐藏）
echo '<div class="comment-list" style="display:none;">';

if (!empty($current_comments)) {
    foreach ($current_comments as $comment) {
        echo '<div class="comment-item">';
        echo '<div class="comment-date">' . get_comment_date('Y年m月d日') . '</div>';
        echo '<div class="comment-content">' . wpautop(get_comment_text($comment->comment_ID)) . '</div>';
        
        // 显示评论标签
        $comment_tags = get_the_terms($comment->comment_ID, 'comment_tag');
        if (!empty($comment_tags)) {
            echo '<div class="comment-tags">';
            foreach ($comment_tags as $tag) {
                echo '<span class="comment-tag">'.$tag->name.'</span>';
            }
            echo '</div>';
        }
        
        echo '</div>';
    }
} else {
    echo '<p class="no-comments">暂无更多</p>';
}

// 显示分页导航
if ($total_comments > $comments_per_page) {
    echo '<div class="comment-pagination">';
    echo paginate_links(array(
        'base' => add_query_arg('paged', '%#%'),
        'format' => '',
        'current' => $paged,
        'total' => ceil($total_comments / $comments_per_page),
        'prev_text' => __('« 上一页'),
        'next_text' => __('下一页 »'),
        'mid_size' => 2
    ));
    echo '</div>';
}

echo '</div>'; // 结束comment-list
?>

<script>
jQuery(document).ready(function($) {
    $('.comments-toggle').click(function() {
        $(this).next('.comment-list').slideToggle('fast');
        $(this).text(function(i, text) {
            return text === '历史记录 (<?php echo $total_comments - 1; ?>)' 
                   ? '隐藏' 
                   : '显示 (<?php echo $total_comments - 1; ?>)';
        });
    });
});
</script>

<style>
.latest-comment {
    margin-bottom: 20px;
    padding: 15px;
    background: #f9f9f9;
    border-left: 3px solid #1e73be;
}

.comment-item {
    margin-bottom: 15px;
    padding-bottom: 15px;
    border-bottom: 1px solid #eee;
}

.comment-date {
    color: #666;
    font-size: 0.9em;
    margin-bottom: 5px;
}

.comment-content {
    line-height: 1.6;
}

.comments-toggle {
    background: #1e73be;
    color: white;
    border: none;
    padding: 8px 15px;
    cursor: pointer;
    border-radius: 3px;
    margin-bottom: 15px;
}

.comments-toggle:hover {
    background: #135e96;
}

.comment-pagination {
    margin-top: 20px;
    text-align: center;
}

.comment-pagination a, 
.comment-pagination span {
    margin: 0 5px;
    padding: 5px 10px;
    display: inline-block;
}

.comment-pagination a {
    background: #f9f9f9;
    color: #1e73be;
    text-decoration: none;
}

.comment-pagination a:hover {
    background: #eee;
}

.comment-pagination .current {
    background: #1e73be;
    color: white;
}

.comment-tag-filter {
    margin-bottom: 20px;
}

.comment-tag-filter a {
    display: inline-block;
    margin-right: 10px;
    padding: 3px 8px;
    background: #f0f0f0;
    color: #333;
    text-decoration: none;
    border-radius: 3px;
}

.comment-tag-filter a.active {
    background: #1e73be;
    color: white;
}

.comment-tags {
    margin-top: 8px;
}

.comment-tag {
    display: inline-block;
    margin-right: 5px;
    padding: 2px 6px;
    background: #e6f2ff;
    color: #1e73be;
    font-size: 0.8em;
    border-radius: 3px;
}
</style>

