
<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <form method="post" action="options.php">
        <?php settings_fields('acs_comment_style_group'); ?>
        
        <div class="acs-settings-container">
            <h2><?= esc_html__('评论样式设置', 'acs') ?></h2>
            
            <div class="acs-style-selector">
                <?php foreach (ACS_Comment_Style::$presets as $id => $preset): ?>
                    <div class="acs-style-option">
                        <input type="radio" id="style_<?= esc_attr($id) ?>" 
                               name="acs_comment_style" 
                               value="<?= esc_attr($id) ?>"
                               <?php checked(get_option('acs_comment_style'), $id); ?>>
                        <label for="style_<?= esc_attr($id) ?>">
                            <?= esc_html($preset['name']) ?>
                        </label>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="acs-custom-css">
                <h3><?= esc_html__('自定义CSS', 'acs') ?></h3>
                <textarea name="acs_comment_custom_css" rows="10"><?= esc_textarea(get_option('acs_comment_custom_css')) ?></textarea>
            </div>
        </div>
        
        <?php submit_button(); ?>
    </form>
</div>
