<?php
// admin/style-settings.php
class Comment_Style_Settings {
    public static function init() {
        add_action('admin_menu', [__CLASS__, 'add_settings_page']);
        add_action('admin_init', [__CLASS__, 'register_settings']);
    }

    public static function add_settings_page() {
        add_submenu_page(
            'options-general.php',
            __('Comment Styles', 'cs'),
            __('Comment Styles', 'cs'),
            'manage_options',
            'comment-styles',
            [__CLASS__, 'render_page']
        );
    }

    public static function register_settings() {
        register_setting('cs_style_group', 'cs_style_settings');
        
        add_settings_section(
            'cs_style_section', 
            __('Display Settings', 'cs'), 
            null, 
            'comment-styles'
        );

        add_settings_field(
            'highlight_authors', 
            __('Highlight Author Comments', 'cs'), 
            [__CLASS__, 'render_checkbox'], 
            'comment-styles',
            'cs_style_section',
            ['name' => 'highlight_authors']
        );
    }
}



?>


