<?php
/**
 * Plugin Update Handler
 * Version: 1.2.1
 */
defined('ABSPATH') or die('Direct access denied');

class ACS_Plugin_Updater {
    private $update_server = 'http://mirror.wuchai.net/wuchai/wordpress/plugins/wuchai-transfer-comments/latest/latest.zip';
    private $temp_dir = '';
    
    public function __construct() {
        $this->temp_dir = get_temp_dir();
        add_action('admin_post_acs_plugin_update', [$this, 'handle_update_request']);
    }

    public function handle_update_request() {
        check_admin_referer('acs_update_nonce');
        
        if (!current_user_can('update_plugins')) {
            wp_die(__('您没有更新插件的权限'));
        }

        $this->download_update_package();
        $this->verify_package();
        $this->install_update();
        
        wp_redirect(admin_url('admin.php?page=acs-comments-update&updated=1'));
        exit;
    }

    private function download_update_package() {
        $response = wp_remote_get($this->update_server, [
            'timeout' => 300,
            'body' => [
                'action' => 'get_package',
                'slug' => 'acs-comments',
                'version' => ACS_PLUGIN_VERSION
            ]
        ]);

        if (is_wp_error($response)) {
            wp_die('下载失败: ' . $response->get_error_message());
        }

        $package_data = wp_remote_retrieve_body($response);
        file_put_contents($this->temp_dir . 'acs-update.zip', $package_data);
    }

    private function verify_package() {
        if (!file_exists($this->temp_dir . 'acs-update.zip')) {
            wp_die('更新包验证失败: 文件不存在');
        }

        if (filesize($this->temp_dir . 'acs-update.zip') < 1024) {
            unlink($this->temp_dir . 'acs-update.zip');
            wp_die('更新包验证失败: 文件大小异常');
        }
    }

    private function install_update() {
        WP_Filesystem();
        $unzip_result = unzip_file(
            $this->temp_dir . 'acs-update.zip', 
            WP_PLUGIN_DIR
        );

        if (is_wp_error($unzip_result)) {
            wp_die('解压失败: ' . $unzip_result->get_error_message());
        }

        unlink($this->temp_dir . 'acs-update.zip');
    }
}

new ACS_Plugin_Updater();
