
jQuery(function($) {
    $(document).on('click', '.acs-load-more', function(e) {
        e.preventDefault();
        var button = $(this);
        var container = button.closest('.acs-comments-container');
        var nextPage = parseInt(button.data('page')) + 1;
        
        $.ajax({
            url: acs_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'acs_load_more_comments',
                post_id: button.data('post-id'),
                page: nextPage,
                nonce: acs_ajax.nonce
            },
            beforeSend: function() {
                button.text('加载中...');
            },
            success: function(response) {
                if (response.success) {
                    container.find('.acs-comments-list').append(response.data.html);
                    button.data('page', nextPage);
                    
                    if (!response.data.has_more) {
                        button.remove();
                    } else {
                        button.text('加载更多评论');
                    }
                }
            }
        });
    });
});
