<?php
class ACS_Comment_Query {
    public static function get_popular_comments($limit = 5) {
        $args = [
            'status' => 'approve',
            'number' => $limit,
            'orderby' => 'comment_count',
            'order' => 'DESC'
        ];
        return get_comments($args);
    }

    public static function get_recent_comments($limit = 5) {
        $args = [
            'status' => 'approve',
            'number' => $limit,
            'orderby' => 'comment_date',
            'order' => 'DESC'
        ];
        return get_comments($args);
    }

    public static function get_comments_by_post($post_id, $paged = 1) {
        $args = [
            'post_id' => $post_id,
            'status' => 'approve',
            'number' => 10,
            'paged' => $paged,
            'order' => 'DESC'
        ];
        return new WP_Comment_Query($args);
    }
}
