<?php
class ACS_Settings_Page {
    public static function render_main_page() {
        // 主设置页面HTML
        //self::load_template('main-page.php');
        $current_style = get_option('acs_comment_style', 'default');
        $custom_css = get_option('acs_comment_custom_css', '');
        include plugin_dir_path(__FILE__) . 'templates/main-page.php';
    }

    public static function render_style_page() {
        // 样式设置页面HTML
        //self::load_template('style-settings.php');
        $current_style = get_option('acs_comment_style', 'default');
        $custom_css = get_option('acs_comment_custom_css', '');

        include plugin_dir_path(__FILE__) . 'templates/settings-page.php';
        
        
    }

    public static function render_content_page() {
        // 内容调用设置页面HTML
        self::load_template('content-settings.php');
    }
     private static function load_template($template_name) {
        $template_path = plugin_dir_path(__FILE__) . 'templates/' . $template_name;
        if(file_exists($template_path)) {
            include $template_path;
        } else {
            echo '<div class="error"><p>模板文件缺失: '. esc_html($template_name) .'</p></div>';
        }
    }
}



/*

class ACS_Comment_Style {
    private static $presets = [
        'default' => ['name' => '默认样式', 'css_class' => 'acs-default'],
        'dark'    => ['name' => '暗黑模式', 'css_class' => 'acs-dark'],
        'minimal' => ['name' => '极简风格', 'css_class' => 'acs-minimal']
    ];

    public static function init() {
        add_action('admin_menu', [__CLASS__, 'add_settings_page']);
        add_action('comment_form', [__CLASS__, 'apply_comment_style']);
        add_filter('plugin_action_links_' . plugin_basename(__FILE__), [__CLASS__, 'add_settings_link']);
    }

    public static function add_settings_page() {
        add_submenu_page(
            'edit-comments.php',
            '评论样式设置',
            '评论样式',
            'manage_options',
            'acs-comment-style',
            [__CLASS__, 'render_settings_page']
        );
    }

    public static function render_settings_page() {
        $current_style = get_option('acs_comment_style', 'default');
        $custom_css = get_option('acs_comment_custom_css', '');

        include plugin_dir_path(__FILE__) . 'templates/settings-page.php';
    }

    public static function apply_comment_style() {
        $style = get_option('acs_comment_style', 'default');
        echo '<div class="' . esc_attr(self::$presets[$style]['css_class']) . '">';
    }
}
ACS_Comment_Style::init();

*/


