<?php
if (!defined('WPINC')) die;

class ACS_Comment_Handler {
    public static function init() {
        add_filter('comment_form_defaults', [__CLASS__, 'custom_comment_form']);
        add_action('wp_enqueue_scripts', [__CLASS__, 'enqueue_assets']);
    }

    public static function custom_comment_form($defaults) {
        $defaults['title_reply'] = __('Join Discussion', 'acs');
        $defaults['comment_field'] = self::get_comment_field();
        return $defaults;
    }

    private static function get_comment_field() {
        ob_start(); ?>
        <div class="acs-comment-box">
            <textarea id="acs-comment" name="comment" required></textarea>
            <div class="acs-toolbar">
                <!-- 工具栏HTML -->
            </div>
        </div>
        <?php return ob_get_clean();
    }

    public static function enqueue_assets() {
        wp_enqueue_style('acs-frontend', ACS_PLUGIN_URL . 'assets/css/frontend.css');
        wp_enqueue_script('acs-ajax', ACS_PLUGIN_URL . 'assets/js/ajax-comments.js', ['jquery'], null, true);
        wp_localize_script('acs-ajax', 'acsData', [
            'ajaxurl' => admin_url('admin-ajax.php')
        ]);
    }
}
ACS_Comment_Handler::init();
