<?php
class ACS_Style_Settings {
    private static $presets = [
        'default' => ['name' => '默认样式', 'preview_color' => '#f0f0f1'],
        'dark'    => ['name' => '暗黑模式', 'preview_color' => '#1e1e1e'],
        'minimal' => ['name' => '极简风格', 'preview_color' => '#ffffff']
    ];

    public static function init() {
        register_setting('acs_style_group', 'acs_comment_style');
        register_setting('acs_style_group', 'acs_comment_custom_css');
        add_action('admin_enqueue_scripts', [__CLASS__, 'enqueue_admin_assets']);
    }

    public static function render_page() {
        $current_style = get_option('acs_comment_style', 'default');
        $custom_css = get_option('acs_comment_custom_css', '');
        include ACS_PLUGIN_DIR . 'templates/admin/style-settings.php';
    }
}
ACS_Style_Settings::init();
