<div class="wrap">
    <h1><?= esc_html__('评论样式设置', 'acs') ?></h1>
    
    <form method="post" action="options.php">
        <?php settings_fields('acs_comment_style_group'); ?>
        
        <div class="acs-style-preview" style="background:<?= esc_attr($args['presets'][$args['current_style']]['preview_color']) ?>">
            <div class="acs-demo-comment">
                <p>这是样式预览效果</p>
            </div>
        </div>

        <table class="form-table">
            <tr>
                <th scope="row"><?= esc_html__('预设样式', 'acs') ?></th>
                <td>
                    <?php foreach ($args['presets'] as $id => $preset): ?>
                        <label class="acs-preset-option">
                            <input type="radio" name="acs_comment_style" 
                                   value="<?= esc_attr($id) ?>" 
                                   <?php checked($args['current_style'], $id); ?>>
                            <?= esc_html($preset['name']) ?>
                        </label><br>
                    <?php endforeach; ?>
                </td>
            </tr>
            <tr>
                <th scope="row"><?= esc_html__('自定义CSS', 'acs') ?></th>
                <td>
                    <textarea name="acs_comment_custom_css" rows="10" class="large-text code"><?= 
                        esc_textarea($args['custom_css']) 
                    ?></textarea>
                </td>
            </tr>
        </table>
        
        <?php submit_button(__('保存设置', 'acs')); ?>
    </form>
</div>
