<div class="wrap">
    <h1><?= esc_html__('评论样式设置', 'acs') ?></h1>
    
    <form method="post" action="options.php">
        <?php settings_fields('acs_comment_style_group'); ?>
        
        <div class="acs-style-preview" style="background:<?= esc_attr($presets[$current_style]['preview_color']) ?>">
            <!-- 样式预览区域 -->
        </div>

        <table class="form-table">
            <tr>
                <th scope="row"><?= esc_html__('预设样式', 'acs') ?></th>
                <td>
                    <?php foreach ($presets as $id => $preset): ?>
                        <label>
                            <input type="radio" name="acs_comment_style" 
                                   value="<?= esc_attr($id) ?>" 
                                   <?php checked($current_style, $id); ?>>
                            <?= esc_html($preset['name']) ?>
                        </label><br>
                    <?php endforeach; ?>
                </td>
            </tr>
            <tr>
                <th scope="row"><?= esc_html__('自定义CSS', 'acs') ?></th>
                <td>
                    <textarea name="acs_comment_custom_css" rows="10" class="large-text"><?= 
                        esc_textarea($custom_css) 
                    ?></textarea>
                </td>
            </tr>
        </table>
        
        <?php submit_button(); ?>
    </form>
</div>



<div class="wrap">
    <h1>评论样式设置</h1>
    
    <form method="post" action="options.php">
        <?php 
        settings_fields('advanced_comments_style');
        do_settings_sections('comments-style');
        submit_button(); 
        ?>
    </form>

    <div class="card">
        <h3>实时预览</h3>
        <div class="comment-preview">
            <p class="comment-author">示例用户</p>
            <div class="comment-content">这是样式设置后的评论预览效果</div>
            <p class="comment-meta">1天前</p>
        </div>
    </div>
</div>
