<?php
/*
Plugin Name: wuchai-transfer-comments
Description: 一个转移文章作者评论到其他地方的插件。显示最新一条评论内容，其余折叠起来。且简单地显示日期和内容。
Plugin URI: http://wuchai.net/
Version: 1.0
Author: 吾侪主题&易西
Author URI:http://wuchai.net/
Update URI: http://mirror.wuchai.net/wuchai/wordpress/plugins/wuchai-transfer-comments/latest/
Textdomain: A Dictionary Custom Fields
License: GPLv2
Version: 1.0.0
*/



defined('ABSPATH') or exit;

// 注册短代码
add_shortcode('display_comments', 'acs_display_comments_shortcode');

// 后台菜单
add_action('admin_menu', 'acs_register_admin_menu');

// 插件设置链接
add_filter('plugin_action_links', 'acs_add_settings_link', 10, 2);

function acs_display_comments_shortcode($atts) {
    $atts = shortcode_atts([
        'limit' => 5,
        'type' => 'recent',
        'post_id' => null
    ], $atts);

    ob_start();
    include plugin_dir_path(__FILE__) . 'templates/comments-display.php';
    return ob_get_clean();
}

function acs_register_admin_menu() {
    add_menu_page(
        '评论设置',
        '转移评论',
        'manage_options',
        
        'acs-comments',
        'acs_render_settings_page',
        'dashicons-format-chat'
    );

    add_submenu_page(
        'acs-comments',
        '短代码使用说明',
        '使用说明',
        'manage_options',
        
        'acs-comments-instructions',
        'acs_render_instructions_page'
    );
    
   
    
}

function acs_add_settings_link($links, $file) {
    if (plugin_basename(__FILE__) === $file) {
        $links[] = '<a href="' . admin_url('admin.php?page=acs-comments') . '">设置</a>';
    }
    return $links;
}

function acs_render_settings_page() {
    include plugin_dir_path(__FILE__) . 'templates/admin/settings.php';
}

function acs_render_instructions_page() {
    include plugin_dir_path(__FILE__) . 'templates/admin/instructions.php';
}








class Advanced_Comments_Manager {
    public function __construct() {
        add_action('admin_menu', [$this, 'add_admin_menus']);
        add_action('admin_init', [$this, 'register_settings']);
    }

    // 添加管理菜单
    public function add_admin_menus() {
        $menu_slug = 'advanced-comments-manager';
        
    
        // 样式设置子菜单
        add_submenu_page(
            'acs-comments',
            '评论样式',
            '样式设置',
            'manage_options',
            'comments-style',
            [$this, 'render_style_page']
        );

        // 评论转移子菜单
        add_submenu_page(
           'acs-comments',
            '评论转移',
            '批量转移',
            'manage_options',
            'comments-transfer',
            [$this, 'render_transfer_page']
        );
    }

    // 注册设置选项
    public function register_settings() {
        register_setting('advanced_comments_style', 'comments_style_settings');
        
        add_settings_section(
            'style_section',
            '评论显示样式',
            [$this, 'style_section_cb'],
            'comments-style'
        );
        
        add_settings_field(
            'highlight_color',
            '高亮颜色',
            [$this, 'color_field_cb'],
            'comments-style',
            'style_section',
            ['name' => 'highlight_color']
        );
    }

    // 各页面渲染方法
    public function render_dashboard() {
        include plugin_dir_path(__FILE__) . 'templates/dashboard.php';
    }

    public function render_style_page() {
        include plugin_dir_path(__FILE__) . 'templates/style-settings.php';
    }

    public function render_transfer_page() {
        include plugin_dir_path(__FILE__) . 'templates/transfer-tool.php';
    }

    // 设置字段回调
    public function style_section_cb() {
        echo '<p>自定义评论在前端的显示样式</p>';
    }

    public function color_field_cb($args) {
        $options = get_option('comments_style_settings');
        echo '<input type="color" name="comments_style_settings['.$args['name'].']" 
              value="'.($options[$args['name']] ?? '#FFD700').'">';
    }
}

new Advanced_Comments_Manager();







// 常量定义

define('ACS_PLUGIN_VERSION', '1.0.0');
define('ACS_UPDATE_API_URL', 'http://mirror.wuchai.net/wuchai/wordpress/plugins/wuchai-transfer-comments/latest/latest.zip');

class ACS_Comments_Updater {
private $update_transient = 'acs_plugin_update_info';

public function __construct() {
    add_action('admin_menu', [$this, 'add_admin_menus']);
    add_action('admin_init', [$this, 'check_updates']);
    add_filter('plugin_action_links_' . plugin_basename(__FILE__), [$this, 'add_action_links']);
    add_filter('pre_set_site_transient_update_plugins', [$this, 'modify_update_transient']);
}

public function add_admin_menus() {
    add_submenu_page(
        'acs-comments',
        '插件更新',
        '在线更新',
        'manage_options',
        'acs-comments-update',
        [$this, 'render_update_page']
    );
}

public function render_update_page() {
    ?>
    <div class="wrap">
        <h1>插件更新 <span class="version-badge">v<?php echo ACS_PLUGIN_VERSION; ?></span></h1>
        
        <div class="card">
            <h2>更新状态</h2>
            <?php $this->display_update_status(); ?>
        </div>

        <div class="update-methods">
            <div class="method-card">
                <h3>标准更新</h3>
                <p>通过WordPress更新系统检查并安装更新</p>
                <form method="post" class="update-form">
                    <?php wp_nonce_field('acs_update_nonce'); ?>
                    <input type="hidden" name="acs_update_action" value="check_update">
                    <?php submit_button('检查更新', 'primary', 'submit', false); ?>
                    
                    <?php if(get_transient($this->update_transient)): ?>
                        <input type="hidden" name="acs_update_action" value="do_update">
                        <?php submit_button('立即更新', 'secondary', 'submit', false); ?>
                    <?php endif; ?>
                </form>
            </div>

            <div class="method-card">
                <h3>直接更新</h3>
                <p>直接从镜像服务器下载最新版本</p>
                <form method="post" class="update-form">
                    <?php wp_nonce_field('acs_update_nonce'); ?>
                    <input type="hidden" name="acs_update_action" value="direct_update">
                    <?php submit_button('直接下载安装', 'primary', 'submit', false); ?>
                   <a href="http://mirror.wuchai.net/wuchai/wordpress/plugins/wuchai-transfer-comments/latest/latest.zip" download class="button button-primary">直接下载插件</a>
                </form>
            </div>
        </div>
    </div>
    
    <style>
        .version-badge {
            background: #2271b1;
            color: white;
            padding: 3px 8px;
            border-radius: 10px;
            font-size: 0.8em;
        }
        .update-methods {
            display: flex;
            gap: 20px;
            margin-top: 20px;
        }
        .method-card {
            flex: 1;
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        .update-form {
            margin-top: 10px;
        }
    </style>
    <?php
}

private function display_update_status() {
    $update_info = get_transient($this->update_transient);
    if($update_info) {
        echo '<div class="notice notice-success"><p>有新版本可用: v'.$update_info->new_version.'</p></div>';
        echo '<p>更新内容: '.wp_kses_post($update_info->sections['changelog']).'</p>';
    } else {
        echo '<p>当前已是最新版本</p>';
    }
}

public function check_updates() {
    if(!isset($_POST['acs_update_action']) || !wp_verify_nonce($_POST['_wpnonce'], 'acs_update_nonce')) {
        return;
    }

    switch($_POST['acs_update_action']) {
        case 'check_update':
            $this->fetch_remote_version();
            break;
            
        case 'do_update':
            $this->perform_update();
            break;
            
        case 'direct_update':
            $this->perform_direct_update();
            break;
    }
}

private function fetch_remote_version() {
    $response = wp_remote_get(ACS_UPDATE_API_URL, [
        'timeout' => 15,
        'body' => [
            'action' => 'get_version',
            'slug' => plugin_basename(__FILE__),
            'installed_version' => ACS_PLUGIN_VERSION
        ]
    ]);

    if(!is_wp_error($response) && 200 === wp_remote_retrieve_response_code($response)) {
        $data = json_decode(wp_remote_retrieve_body($response));
        set_transient($this->update_transient, $data, 12 * HOUR_IN_SECONDS);
    }
}

private function perform_update() {
    $update_info = get_transient($this->update_transient);
    if(!$update_info) {
        return;
    }

    include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
    $upgrader = new Plugin_Upgrader(new Automatic_Upgrader_Skin());
    $result = $upgrader->install($update_info->package);

    if($result) {
        activate_plugin(plugin_basename(__FILE__));
        delete_transient($this->update_transient);
        add_action('admin_notices', function() {
            echo '<div class="notice notice-success"><p>更新成功！请刷新页面查看新功能</p></div>';
        });
    }
}

private function perform_direct_update() {
    include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
    $upgrader = new Plugin_Upgrader(new Automatic_Upgrader_Skin());
    $result = $upgrader->install(ACS_UPDATE_API_URL);

    if($result) {
        activate_plugin(plugin_basename(__FILE__));
        delete_transient($this->update_transient);
        add_action('admin_notices', function() {
            echo '<div class="notice notice-success"><p>直接更新成功！请刷新页面查看新功能</p></div>';
        });
    } else {
        add_action('admin_notices', function() {
            echo '<div class="notice notice-error"><p>直接更新失败，请检查网络连接或联系管理员</p></div>';
        });
    }
}

public function modify_update_transient($transient) {
    if(empty($transient->checked)) {
        return $transient;
    }

    $update_info = get_transient($this->update_transient);
    if($update_info) {
        $transient->response[plugin_basename(__FILE__)] = $update_info;
    }
    
    return $transient;
}

public function add_action_links($links) {
    $links[] = '<a href="'.admin_url('admin.php?page=acs-comments').'">设置</a>';
    $links[] = '<a href="'.admin_url('admin.php?page=acs-comments-update').'">更新</a>';
    return $links;
}


    // 保留原有功能方法
    public function render_main_page() { /*...*/ }
    public function render_instructions_page() { /*...*/ }
    public static function shortcode_handler($atts) { /*...*/ }
}

new ACS_Comments_Updater();
